/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.SourcePhot;
import cds.aladin.SourceTag;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.tools.VOApp;
import java.util.Enumeration;
import java.util.Iterator;

public class PlanTool
extends PlanCatalog {
    protected boolean movable = true;

    protected PlanTool(Aladin aladin, String label) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 9;
        this.c = Couleur.getNextDefault(aladin.calque);
        if (label == null) {
            label = "Drawing";
        }
        this.setLabel(label);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
        this.askActive = true;
        aladin.calque.selectPlan(this);
        Plan pref = aladin.calque.getPlanRef();
        if (pref == null || !Projection.isOk(pref.projd)) {
            this.projd = new Projection();
            this.hasXYorig = true;
        } else {
            this.hasXYorig = false;
        }
    }

    protected PlanTool(Aladin aladin) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 9;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
        this.askActive = true;
    }

    @Override
    protected boolean Free() {
        if (this.aladin.view.zoomview.flagCut || this.aladin.view.zoomview.flagHist) {
            Iterator<Obj> it = this.iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!o.isSelected()) continue;
                o.remove();
            }
        }
        return super.Free();
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        int n = this.getCounts();
        if (n > 0) {
            PlanTool.ADD(buf, "\n* Objects: ", String.format("%,d", n));
        }
    }

    public SourceTag addTag(ViewSimple v, double ra, double dec) {
        SourceTag o = new SourceTag(this, v, new Coord(ra, dec), null);
        this.pcat.insertSource(o);
        this.aladin.view.newView(1);
        this.setSourceRemovable(true);
        return o;
    }

    public SourcePhot addPhot(ViewSimple v, double ra, double dec, double[] iqe) {
        SourcePhot o = new SourcePhot((Plan)this, v, new Coord(ra, dec), iqe);
        this.pcat.insertSource(o);
        this.aladin.view.newView(1);
        this.setSourceRemovable(true);
        return o;
    }

    @Override
    protected String getInfo() {
        if (this.type == 0) {
            return super.getInfo();
        }
        return this.label + super.addDebugInfo();
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("movable")) {
            this.setMovable(value);
        } else {
            super.setPropertie(prop, specif, value);
        }
    }

    @Override
    protected boolean isMovable() {
        return this.movable;
    }

    @Override
    protected boolean isCatalog() {
        return this.hasTag();
    }

    protected boolean hasTag() {
        if (this.pcat == null) {
            return false;
        }
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof SourceTag)) continue;
            return true;
        }
        return false;
    }

    protected void setMovable(String v) throws Exception {
        if (v.equalsIgnoreCase("On")) {
            this.movable = true;
        } else if (v.equalsIgnoreCase("Off")) {
            this.movable = false;
        } else {
            throw new Exception("Syntax error => movable=on|off");
        }
    }

    protected void setIdAgain() {
        if (this.pcat == null) {
            return;
        }
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Repere)) continue;
            ((Repere)o).setId();
        }
    }

    protected void sendMesureObserver(Obj o, boolean cont) {
        if (this.aladin.VOObsMes == null || this.aladin.VOObsMes.size() == 0) {
            return;
        }
        int objIndex = this.pcat.getIndex(o);
        String s = "set " + Tok.quote(this.label + "/" + objIndex) + " measure=" + o.id + (cont ? " ..." : "");
        Aladin.trace(4, "sendMesureObserver(): [" + s + "]");
        Enumeration e = this.aladin.VOObsMes.elements();
        while (e.hasMoreElements()) {
            try {
                ((VOApp)e.nextElement()).execCommand(s);
            }
            catch (Exception e1) {
                if (Aladin.levelTrace < 3) continue;
                e1.printStackTrace();
            }
        }
    }
}

